﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
//#include "gameProgram/parseVariablePaths.as"
// nestedEval.as
	// evalpath
	// getImpliedValue
	// resolveContainer
define_teleport = function(command_obj)
{
	command_obj.run = function( thisCommand_obj )
	{
		ROOT.game_mc.uid = null;		// interrupt all scripts in this level  (doesn't affect common events)
		
		// remove all loops
		LOOP.removeSet( "player" );
		LOOP.removeSet( "scroll" );
		LOOP.removeSet( "sprites" );
		
		
		// wait for fade-out
		thisCommand_obj.fadeOutDone = function()
		{
			var showTrace = Boolean(TRACE_SCRIPT);
			//var showTrace = true;
			
			if(showTrace)
				trace("teleport");
			// figure out the destination path
			if(!thisCommand_obj.data.forceFullPath)
				var relativePath = thisCommand_obj.data.relativeLevel;		// relative path
			var filePath = thisCommand_obj.data.level;								// full path  (old method)
			if(showTrace){
				trace("  fullPath: "+filePath);
				trace("  relativePath: "+relativePath);
			}
			
			// if:  a relative path exists, use it instead of the full path
			if(relativePath!=undefined && relativePath!="undefined")
			{
				// use relative path by starting at current level path...
				var currentPath = ROOT.level_xml.filePath;
				if(showTrace)
					trace("  currentPath: "+currentPath);
				// ... removing current level filename from the path...
				var endAt = currentPath.lastIndexOf("\\");
				if(endAt==-1)
					var startPath = "";	// avoid cutting off the last char in the path via substr(0,-1)
				else
					var startPath = currentPath.substr(0, endAt+1);  // up to, and including \
				// ... tracing back if relative starts with ".." ...
				var foundAt = -1;
				while( (foundAt=relativePath.indexOf(".."))  !=  -1 )		// this assigns & checks the value at the same time
				{
					// go up one level in startPath
					endAt = startPath.lastIndexOf("\\", endAt-1);	// find the \ before the last one
					startPath = startPath.substr(0, endAt+1);  // up to, and including \
					// remove ..\ from relativePath
					relativePath = relativePath.substr( foundAt+3 );	// jump ahead 3
				}// while:  relative path starts with ..
				// ... and appending relative path.
				filePath = startPath +relativePath;		// startPath\ + relativePath
			}// if:  relative path was specified
			
			// parse variables
			var filePath = nestedEval( filePath, "RAM", "_this" );
			
			// teleport
			if(showTrace)
				trace("  teleporting to: "+filePath);
			// assume strings are variable paths, and add brackets if they're missing
			if(typeof(thisCommand_obj.data.position.x)=="string")
				if(thisCommand_obj.data.position.x.charAt(0)!="[")
					thisCommand_obj.data.position.x = "["+thisCommand_obj.data.position.x+"]";
			if(typeof(thisCommand_obj.data.position.y)=="string")
				if(thisCommand_obj.data.position.y.charAt(0)!="[")
					thisCommand_obj.data.position.y = "["+thisCommand_obj.data.position.y+"]";
			
			var destX = Number( nestedEval( thisCommand_obj.data.position.x, "RAM", "_this" ) );
			var destY = Number( nestedEval( thisCommand_obj.data.position.y, "RAM", "_this" ) );
			if(thisCommand_obj.data.position){
				var newStart = {
					x:destX +8,
					y:destY +8
				}
				var start_point = newStart;
			}else{
				var start_point = {
					x:SPRITES.player._x,
					y:SPRITES.player._y
				}
			}
			// trigger fade-in
			thisCommand_obj.endScript();		// tell the parent script it's being interrupted
			ROOT.loadLevel( filePath, start_point );
//		TRANSITION.fadeIn();					// called automatically by "game_mc" when a map finishes loading
		}// fade-out done()
		
		
		
		if(!LEVEL.alreadyTeleporting)
		{// if:  not already teleporting
			LEVEL.alreadyTeleporting = true;
			// store the player's appearance
			var currentPlayer = SPRITES.player.image.getParams();
			if(currentPlayer)
				RAM.playerSprite = currentPlayer;
			// place transition  &  start everything
			var transitionName = thisCommand_obj.data.transition;
			transitionName = nestedEval( transitionName, "RAM", "_this" );
			TRANSITION.start(transitionName)
				.then(thisCommand_obj.fadeOutDone);
		}// if:  not already teleporting
		
	}// run()
}// define_teleport()